//	OTLN_COutline.h

#ifndef _H_O_COutline
#define _H_O_COutline

#include "O_p.h"
#include "O_CTopic.h"

Err			OTLNg_GetCOutline(OTLN_OutlineH outlineH, OTLN_COutline **coutline);
Err			OTLNpg_OT_2_COT(
	OTLN_OutlineAndTopicP		source, 
	OTLN_COutlineAndCTopicP		dest
);


/*****************************************************************************/

class	OTLN_COutline {

	//DECLARE_RTTC(OTLN_COutline);

/********  Initialize  **********/
public:
			Err						OTLNm_IOutline(
				Err				*operator_err, 
				OTLN_OutlineH	outlineH0
			);

/********  Duplicate  **********/
private:
	static	Err						OTLNspm_DuplicateSelfCB(
 				//	always passed out, but may be ignored
 				OTLN_OutlineAndTopic	*to_source0,
				void					*custom_source, 
 				//	always passed out, but may be ignored
				OTLN_OutlineAndTopic	*to_dest0, 
				void 					**custom_dest
			);
	
			Err						OTLNm_DuplicateSelf(
				OTLN_OutlineAndTopic	*to_source, 
				OTLN_OutlineAndTopic	*to_dest, 
				OTLN_COutline			**duplicate
			);
		
public:	
			Err						OTLNm_Duplicate(OTLN_COutline **duplicate);
		
/********  Dispose  **********/
private:
	static	Err						OTLNspm_DisposeSelfCB(void *custom_data);
			Err						OTLNm_DisposeSelf(void);
public:
			//	DisposeOutline returns an ERROR!   
			//	this is the one you must call!!!
			Err						OTLNm_DisposeOutline(void);
			
			//	Dispose does NOT return an error!!!
			//	be forwarned!  Don't call it!
			void					Dispose(void);

/********  User Callbacks, Custom Data  **********/
		Err				OTLNm_SetCallbackDispatch(
							OTLN_CBDispatchProc user_cb_dispatch_proc
						);
						
		Err				OTLNm_GetCallbackDispatch(
							OTLN_CBDispatchProc *user_cb_dispatch_proc
						);
						
		Err				OTLNm_SetCustomData(void *custom_data);
		Err				OTLNm_GetCustomData(void **custom_data);


/********  set specs  **********/
		Err				OTLNm_SetCellHeight(short height);
		Err				OTLNm_GetCellHeight(short *height);
		Err				OTLNm_SetVisFlags(Boolean *family0, Boolean *topic0);
		Err				OTLNm_GetVisFlags(Boolean *family0, Boolean *topic0);
//	some way to set/get the font info
		
		Err				OTLNm_SetFontInfo(const char *fontName, short fontSize);

		Err				OTLNm_GetOutlineFrame(Rect *frame);
		Err				OTLNm_SetIndentWidth(short indent_width0);
		Err				OTLNm_UpdateBounds(void);
		
/********  access  **********/
		Err				OTLNm_GetRootTopic(OTLN_CTopic **root_topic);
		Err				OTLNm_GetFirstTopic(OTLN_CTopic **first_topic);

/********  creating the outline  **********/
		Err				OTLNm_SetRecent(OTLN_CTopic *recent);
		Err				OTLNm_GetRecent(OTLN_CTopic **recent);
		
		Err				OTLNm_NewTopic(
			const	char			*name0, 
					OTLN_TopicH		topicH0, 
					OTLN_CTopic		**newTopic
		);

		Err				OTLNm_AddNewTopic(
			const	char				*name0, 
					//	where i go in parent's list of children
					OTLN_CTopicIndex	index, 	
					OTLN_CTopic			**new_topic0
		);
		
		Err		OTLNm_GetOutlineState(OTLN_OutlineSaveH *otln);
		Err		OTLNm_SetOutlineState(OTLN_OutlineSaveH *otln);

/********  iterate  **********/
private:
		static		Err		OTLNpsm_InternalCBDispatchProcCB(
			OTLN_COutlineAndCTopicP	cot, 
			OTLN_CBType				cbType, 
			OTLN_CBDataP			cbData
		);

		static		Err		OTLNpsm_DeepIterateCB(
			OTLN_OutlineH				outline, 
			OTLN_TopicH					topic, 
			void						*custom_data, 
			OTLN_GenericCallbackData	*callback_data
		);

public:	//	not private so CTopics may access
		//	if CTopics have their own, make this private again
		Err				OTLNm_InternalCBDispatchProc(
			OTLN_COutlineAndCTopicP	cot, 
			OTLN_CBType				cbType, 
			OTLN_CBDataP			cbData
		);

		Err				OTLNm_ApplyToItems(
			OTLN_COutlineIterateType	iterate_type, 
			OTLN_CBType					cb_type, 
			void						*data
		);

		Err				OTLNm_CountVisibleCells(long *items);
		Err				OTLNm_CountVisibleItems(long *items);
		Err				OTLNm_CountSelectedItems(long *items);
		Err				OTLNm_Draw(Boolean scrub, long *v_bottom0);
		Err				OTLNm_HitTest(Point hit_point, OTLN_CTopic **ctopic);
		Err				OTLNm_SelectAll(
							Boolean select, Boolean draw, OTLN_CTopic *except0
						);
						
		Err				OTLNm_ClearRects(void);

/********  operators  **********/
		OTLN_OutlineH		operator=(OTLN_COutline *coutline);
		OTLN_COutline		*operator=(OTLN_OutlineH outlineH);
		
		

/********  variables  **********/
private:
		OTLN_CBDispatchProc		OTLNpi_user_cb_dispatch_proc;
		void					*OTLNpi_custom_data;
		
		//	true when in the middle of dispose call
		Boolean					OTLNpi_disposing;
		Err						*OTLNpi_operator_err;

public:	//	so that CTopics may access it
		OTLN_OutlineH			OTLNi_outlineH;
		short					OTLNpi_indent_width0;
		
		//	after OTLNm_Draw, this contains the largest vertical
		//	pixel position (bottom - most)
		//	not used directly by user, but passed back from OTLNm_Draw
		long					i_v_bottom;
};

#endif _H_OTLN_COutline
